/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.math;

import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;

public class ChunkSectionPos
extends Vec3i {
    private ChunkSectionPos(int i, int j, int k) {
        super(i, j, k);
    }

    public static ChunkSectionPos from(int x, int y, int z) {
        return new ChunkSectionPos(x, y, z);
    }

    public static ChunkSectionPos from(BlockPos pos) {
        return new ChunkSectionPos(ChunkSectionPos.getSectionCoord(pos.func_177958_n()), ChunkSectionPos.getSectionCoord(pos.func_177956_o()), ChunkSectionPos.getSectionCoord(pos.func_177952_p()));
    }

    public static ChunkSectionPos from(ChunkPos chunkPos, int y) {
        return new ChunkSectionPos(chunkPos.field_77276_a, y, chunkPos.field_77275_b);
    }

    public static ChunkSectionPos from(Entity entity) {
        return new ChunkSectionPos(ChunkSectionPos.getSectionCoord(MathHelper.func_76141_d((float)entity.func_180425_c().func_177958_n())), ChunkSectionPos.getSectionCoord(MathHelper.func_76141_d((float)entity.func_180425_c().func_177956_o())), ChunkSectionPos.getSectionCoord(MathHelper.func_76141_d((float)entity.func_180425_c().func_177952_p())));
    }

    public static ChunkSectionPos from(long packed) {
        return new ChunkSectionPos(ChunkSectionPos.unpackX(packed), ChunkSectionPos.unpackY(packed), ChunkSectionPos.unpackZ(packed));
    }

    public static long offset(long packed, EnumFacing direction) {
        return ChunkSectionPos.offset(packed, direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e());
    }

    public static long offset(long packed, int x, int y, int z) {
        return ChunkSectionPos.asLong(ChunkSectionPos.unpackX(packed) + x, ChunkSectionPos.unpackY(packed) + y, ChunkSectionPos.unpackZ(packed) + z);
    }

    public static int getSectionCoord(int coord) {
        return coord >> 4;
    }

    public static int getLocalCoord(int coord) {
        return coord & 0xF;
    }

    public static short packLocal(BlockPos pos) {
        int i = ChunkSectionPos.getLocalCoord(pos.func_177958_n());
        int j = ChunkSectionPos.getLocalCoord(pos.func_177956_o());
        int k = ChunkSectionPos.getLocalCoord(pos.func_177952_p());
        return (short)(i << 8 | k << 4 | j);
    }

    public static int unpackLocalX(short packedLocalPos) {
        return packedLocalPos >>> 8 & 0xF;
    }

    public static int unpackLocalY(short packedLocalPos) {
        return packedLocalPos & 0xF;
    }

    public static int unpackLocalZ(short packedLocalPos) {
        return packedLocalPos >>> 4 & 0xF;
    }

    public static int getBlockCoord(int sectionCoord) {
        return sectionCoord << 4;
    }

    public static int unpackX(long packed) {
        return (int)(packed >> 42);
    }

    public static int unpackY(long packed) {
        return (int)(packed << 44 >> 44);
    }

    public static int unpackZ(long packed) {
        return (int)(packed << 22 >> 42);
    }

    public static long fromBlockPos(long blockPos) {
        BlockPos pos = BlockPos.func_177969_a((long)blockPos);
        return ChunkSectionPos.asLong(ChunkSectionPos.getSectionCoord(pos.func_177958_n()), ChunkSectionPos.getSectionCoord(pos.func_177956_o()), ChunkSectionPos.getSectionCoord(pos.func_177952_p()));
    }

    public static long withZeroY(long pos) {
        return pos & 0xFFFFFFFFFFF00000L;
    }

    public static long asLong(int x, int y, int z) {
        long l = 0L;
        l |= ((long)x & 0x3FFFFFL) << 42;
        l |= (long)y & 0xFFFFFL;
        return l |= ((long)z & 0x3FFFFFL) << 20;
    }

    public int unpackBlockX(short packedLocalPos) {
        return this.getMinX() + ChunkSectionPos.unpackLocalX(packedLocalPos);
    }

    public int unpackBlockY(short packedLocalPos) {
        return this.getMinY() + ChunkSectionPos.unpackLocalY(packedLocalPos);
    }

    public int unpackBlockZ(short packedLocalPos) {
        return this.getMinZ() + ChunkSectionPos.unpackLocalZ(packedLocalPos);
    }

    public BlockPos unpackBlockPos(short packedLocalPos) {
        return new BlockPos(this.unpackBlockX(packedLocalPos), this.unpackBlockY(packedLocalPos), this.unpackBlockZ(packedLocalPos));
    }

    public int getSectionX() {
        return this.func_177958_n();
    }

    public int getSectionY() {
        return this.func_177956_o();
    }

    public int getSectionZ() {
        return this.func_177952_p();
    }

    public int getMinX() {
        return this.getSectionX() << 4;
    }

    public int getMinY() {
        return this.getSectionY() << 4;
    }

    public int getMinZ() {
        return this.getSectionZ() << 4;
    }

    public int getMaxX() {
        return (this.getSectionX() << 4) + 15;
    }

    public int getMaxY() {
        return (this.getSectionY() << 4) + 15;
    }

    public int getMaxZ() {
        return (this.getSectionZ() << 4) + 15;
    }

    public BlockPos getMinPos() {
        return new BlockPos(ChunkSectionPos.getBlockCoord(this.getSectionX()), ChunkSectionPos.getBlockCoord(this.getSectionY()), ChunkSectionPos.getBlockCoord(this.getSectionZ()));
    }

    public BlockPos getCenterPos() {
        return this.getMinPos().func_177982_a(8, 8, 8);
    }

    public ChunkPos toChunkPos() {
        return new ChunkPos(this.getSectionX(), this.getSectionZ());
    }

    public long asLong() {
        return ChunkSectionPos.asLong(this.getSectionX(), this.getSectionY(), this.getSectionZ());
    }

    public Iterable<BlockPos> streamBlocks() {
        return BlockPos.func_191532_a((int)this.getMinX(), (int)this.getMinY(), (int)this.getMinZ(), (int)this.getMaxX(), (int)this.getMaxY(), (int)this.getMaxZ());
    }
}

